//
//  DisplayDetailsViewController.swift
//  BackAnimation
//
//  Created by 9Brainz on 15/12/18.
//  Copyright © 2018 9Brainz. All rights reserved.
//

import UIKit

class DisplayDetailsViewController: UIViewController
{
    @IBOutlet weak var vwBackground: UIView!
    @IBOutlet weak var imgSelected: UIImageView!
    @IBOutlet weak var cvSelectedCollection: UICollectionView!
    
    var strSelcted = String()
    var arrCollection = Array<Any>()
    var isBack = false

    override func viewDidLoad()
    {
        
        super.viewDidLoad()
        vwBackground.isHidden = true
        self.navigationController?.isNavigationBarHidden = true
    }
    
}

extension DisplayDetailsViewController : UICollectionViewDelegate,UICollectionViewDataSource,UICollectionViewDelegateFlowLayout
{
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return arrCollection.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell
    {
        let cell : DisplayPictureCollectionViewCell = collectionView.dequeueReusableCell(withReuseIdentifier: "DisplayPictureCollectionViewCell", for: indexPath as IndexPath) as! DisplayPictureCollectionViewCell
        if indexPath.item == 0
        {
            cell.imgCollection.image = UIImage(named: "\(strSelcted)")
            
            let panGesture = UIPanGestureRecognizer(target: self, action: #selector(self.handlePanGesture(_:)))
            cell.imgCollection.isUserInteractionEnabled = true
            cell.imgCollection.addGestureRecognizer(panGesture)
        }
        else
        {
            cell.imgCollection.image = UIImage(named: "\(arrCollection[indexPath.row])")
        }
        return cell
        
    }
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize
    {
        var witdhOfCell = CGFloat()
        var heightOfCell = CGFloat()
        let imgSize = UIImage(named: "\(arrCollection[indexPath.row])")?.size
        if indexPath.item == 0
        {
            witdhOfCell = (SCREEN_WIDTH ) - 16
            heightOfCell = 360
        }
        else
        {
            if Float((imgSize?.width)!) > Float((imgSize?.height)!)
            {
                witdhOfCell = (SCREEN_WIDTH / 2) - 16
                heightOfCell = (SCREEN_WIDTH * 80) / 165
            }
            else
            {
                witdhOfCell = (SCREEN_WIDTH / 2) - 16
                heightOfCell = (SCREEN_WIDTH * 80) / 120
            }
        }
        return CGSize(width: witdhOfCell, height: heightOfCell)
    }
}

extension DisplayDetailsViewController : UIGestureRecognizerDelegate
{

    @objc func handlePanGesture(_ panGesture: UIPanGestureRecognizer)
    {
        self.view.bringSubviewToFront(imgSelected)
        let translation = panGesture.translation(in: self.view)
         print(imgSelected.center.y  + translation.y)
        if translation.y > 0
        {
            self.isBack = true
            imgSelected.center = CGPoint(x: imgSelected.center.x + translation.x, y: imgSelected.center.y + translation.y)
        }
        
        panGesture.setTranslation(CGPoint.zero, in: self.view)
    
        if panGesture.state == UIGestureRecognizer.State.ended
        {
            if isBack
            {
                self.navigationController?.isNavigationBarHidden = false

                self.navigationController?.popViewController(animated: true)
            }
        }
        if panGesture.state == UIGestureRecognizer.State.changed
        {
            if isBack
            {
                imgSelected.image = UIImage(named: "\(strSelcted)")
                setView(view: vwBackground, hidden: false)
            }
        }
        else
        {
            setView(view: vwBackground, hidden: true)
        }
    }

    func setView(view: UIView, hidden: Bool)
    {
        UIView.transition(with: view, duration: 1, options: .transitionCrossDissolve, animations:
        {
            view.isHidden = hidden
        })
    }
}
